/*******************************************************************************
*                         USB4ALLAPI Library Version 1.0                       *
*******************************************************************************/
#ifndef _CONF_H_
#define _CONF_H_

typedef struct {
    int epnum;
    int tdscin;
    int tdscout;
} dscEndpoint;

// Definicin de constantes generales.
#define _API_VERSION        1

// Clases que implementan las interfases de la API.
#define _iCOMMANDLAYER_         "CommandManager.h"
#define _iCOMMANDLAYER          CommandManager
#define _iHANDLERLAYER_         "ModuleManager.h"
#define _iHANDLERLAYER          ModuleManager
#define _iDESCRIPTORLAYER_      "DescriptorManager.h"
#define _iDESCRIPTORLAYER       DescriptorManager

// Definiciones sensibles a la plataforma.
#ifdef _PLATFORM_WIN32
    // Vid y Pid de la plataforma
    #define _VID    0x04d8
    #define _PID    0x000c
    // Exportacin/Importacin de simbolos
    #ifdef _BUILDING_USB4ALLAPI
        #define _IMPEXP_USB4ALLAPI __declspec(dllexport)
    #else
        #define _IMPEXP_USB4ALLAPI __declspec(dllimport)
    #endif
    // Seleccin del driver
    #ifdef _DRIVER_MICROCHIP
        #define _MCHP_VIDPID    "vid_04d8&pid_000c"
        #define _DRIVER_        "DriverMCHP.h"
        #define _DRIVER         DriverMCHP
        typedef struct {
            int serial;
            int qtyep;
            dscEndpoint eps[15];
        } itemBoard;
    #endif
    #ifdef _DRIVER_LIBUSBWIN32
        #define _LIBUSBWIN32_VID    0x04d8
        #define _LIBUSBWIN32_PID    0x000c
        #define _DRIVER_    "DriverLibUsbWin32.h"
        #define _DRIVER     DriverLibUsbWin32
        typedef struct {
            int serial;
            int qtyep;
            struct usb_dev_handle *devhnd;
            dscEndpoint eps[15];
        } itemBoard;
    #endif
    // Representacin de los descriptores del Baseboard.
    const int BUFFER_SIZE = 2048;
    typedef struct _itemDsc{
        char rhubname[BUFFER_SIZE];
        int port;
        int qtyep;
        char stdDeviceDsc[BUFFER_SIZE];
        char strManufacturer[255];
        char strProduct[255];
        char strSerialNumber[255];
        char stdConfigurationDsc[9];
        char stdInterfaceDsc[9];
        char stdEndpointDsc[15][7];
    } itemDsc;
    // Clase que implementa la lgica de la plataforma.
    #define _iPLATFORMLAYER_    "PlatformWin32.h"
    #define _iPLATFORMLAYER     PlatformWin32
#endif
#ifdef _PLATFORM_LINUX
    // Exportacin/Importacin de simbolos
    #define _IMPEXP_USB4ALLAPI ""
    // Seleccin del driver
    #ifdef _DRIVER_LIBUSB
        #define _DRIVER_    "DriverLibUsb.h"
        #define _DRIVER     DriverLibUsb
    #endif
    #ifdef _DRIVER_CUSTOM
        #define _DRIVER_    "DriverCustom.h"
        #define _DRIVER     DriverCustom
    #endif
    // Representacin de los descriptores del Baseboard.

    // Clase que implementa la lgica de la plataforma.
    #define _iPLATFORMLAYER_    "PlatformWin32.h"
    #define _iPLATFORMLAYER     PlatformWin32
#endif

#endif
